﻿using System;
using System.Collections.Generic;

namespace Microscopic_Traffic_Simulator.ViewModels.Messages
{
    /// <summary>
    /// Class representing messenger for communicating between viewmodels.
    /// </summary>
    class Messenger
    {
        /// <summary>
        /// Dictionary of messages.
        /// </summary>
        Dictionary<Type, MessageBase> messages = new Dictionary<Type, MessageBase>();

        /// <summary>
        /// Get message from messenger. If the message does not exist in messenger it is created.
        /// </summary>
        /// <typeparam name="TMessage">Type of the message.</typeparam>
        /// <returns>Message object.</returns>
        public TMessage GetEvent<TMessage>() where TMessage : MessageBase
        {
            Type messageType = typeof(TMessage);
            if (messages.ContainsKey(messageType))
            {
                return (TMessage)messages[messageType];
            }
            else
            {
                TMessage message = (TMessage)Activator.CreateInstance(messageType);
                messages.Add(messageType, message);
                return message;
            }
        }
    }
}
